/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

#define PI 3.14159265359
//uniform float time;
//uniform vec2 mouse;
//uniform vec2 resolution;

mat2 rotate2d(float _angle){
    return mat2(cos(_angle),-sin(_angle),
                sin(_angle),cos(_angle));
}

vec3 hsv(float h, float s, float v)
{
  return mix(vec3(1.0),clamp((abs(fract(
    h+vec3(3.0, 2.0, 1.0)/3.0)*6.0-3.0)-1.0), 0.0, 1.0),s)*v;
}

float shape(vec2 p)
{
    return abs(p.x)+abs(p.y)-1.0;
}

void main( void ) {
	vec2 uv = scaled_gl_FragCoord.xy/resolution.xy;
	vec2 pos = uv*2.0-1.0;
	pos.x *= resolution.x/resolution.y;
	pos = pos*cos(0.00005)+vec2(pos.y,-pos.x)*sin(0.00005);
	pos = mod(pos*4.0, 2.0)-1.0;
	uv -= vec2(0.5);
	pos = rotate2d( sin(time)*PI ) * pos;
	uv += vec2(0.5);
	float c= 0.05/abs(sin(0.3*shape(3.0*pos)));
	vec3 col = hsv(fract(0.1*time),1.0,1.0);
	gl_FragColor.rgb = col*c;
   gl_FragColor.a = length(gl_FragColor.rgb);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}